This repository is the official implementation of GNN-LF:


#### Requirements
Tested combination: Python 3.9.6 + [PyTorch 1.11.0](https://pytorch.org/get-started/previous-versions/)

Other required python libraries include: numpy, scikit-learn, optuna, torch_geometric, etc.

#### Prepare Data
We write a script for preparing datasets.
```
python prepare_dataset.py
```

#### Reproduce Results on MD17
To reproduce results of the benzene molecule.
```
python main_md17_final.py --dataset benzene --test 
```

"benzene" can be replaced with other molecules: benzene, uracil, naphthalene, aspirin, salicylic_acid, malonaldehyde, ethanol, toluene


To do ablation analysis.

NoDir2
```
python main_md17_final.py --nodir2 --dataset benzene --test 
```

NoDir3
```
python main_md17_final.py --nodir3 --dataset benzene --test 
```

Global
```
python main_md17_final.py --global_frame --dataset benzene --test 
```

NoDecomp
```
python main_md17_final.py --no_filter_decomp --dataset benzene --test 
```

NoShare
```
python main_md17_final.py --no_share_filter --dataset benzene --test 
```

####  Reproduce Results on QM9
To reproduce results of the homo target
```
python main_qm9.py --dataset homo --test
```
"homo" can be replaced with other targets: dipole_moment, isotropic_polarizability, homo, lumo, gap, electronic_spatial_extent, zpve, energy_U0, energy_U, enthalpy_H, free_energy, heat_capacity

###  Search Hyperparameters
On MD17
```
python main_md17.py --dataset benzene
```
On QM9
```
python main_qm9.py --dataset homo
```